/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.search;

import filenet.vw.api.VWQueue;
import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.search.IVWAdminPerformSearchListener;
import filenet.vw.toolkit.admin.search.VWAdminPerformSearchEvent;
import filenet.vw.toolkit.admin.search.VWBaseSearchOptions;
import filenet.vw.toolkit.admin.search.VWEventLogSearchOptions;
import filenet.vw.toolkit.admin.search.VWStatisticsSearchOptions;
import filenet.vw.toolkit.admin.search.VWWorkflowObjectSearchOptions;
import filenet.vw.toolkit.admin.search.VWWorkflowSearchOptions;
import filenet.vw.toolkit.admin.search.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.dialog.VWConfirmYesNoDialog;
import filenet.vw.toolkit.utils.query.IVWScopeChangeListener;
import filenet.vw.toolkit.utils.query.VWFilterConditionsPanel;
import filenet.vw.toolkit.utils.query.VWRosterQueueSelectionPanel;
import filenet.vw.toolkit.utils.query.VWScopeChangeEvent;
import filenet.vw.toolkit.utils.query.VWSelectColumnsPanel;
import filenet.vw.toolkit.utils.query.VWUserSelectionPanel;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.table.VWQuickSort;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class VWAdminSearchCategoryPanel
extends JPanel
implements ActionListener,
ChangeListener {
    private static final int MAX_RETURNED_PER_SET_SOFT_LIMIT = 1000;
    private JComboBox m_resultTypeCMB = null;
    private JComboBox m_scopeCMB = null;
    private JComboBox m_specificScopeCMB = null;
    private JButton m_executeButton = null;
    private JButton m_newSearchButton = null;
    private JButton m_searchCountButton = null;
    private ButtonGroup m_buttonGroup = null;
    private JRadioButton m_readRadioButton = null;
    private JRadioButton m_editRadioButton = null;
    private JTextField m_maxReturnedTextField = null;
    private Color m_enabledBkgrndColor = SystemColor.text;
    private boolean m_bDetailMode = false;
    private JTabbedPane m_searchTab = null;
    private Frame m_parentFrame = null;
    private JPanel m_parentPanel = null;
    private VWSession m_vwSession = null;
    private int m_maxReturned = 50;
    private EventListenerList m_searchListenerList = null;
    private Vector m_visiblePanels = null;
    private VWFilterConditionsPanel m_filterConditionsPanel = null;
    private VWSelectColumnsPanel m_selectColumnsPanel = null;
    private VWUserSelectionPanel m_userSelectionPanel = null;
    private VWRosterQueueSelectionPanel m_rosterQueueSelectionPanel = null;
    private boolean m_bCurrentTime = true;
    private VWLabelListCellRenderer m_customComBoBoxRenderer = new VWLabelListCellRenderer();

    public VWAdminSearchCategoryPanel(Frame parentFrame, JPanel parentPanel) {
        try {
            this.m_parentFrame = parentFrame;
            this.m_parentPanel = parentPanel;
            this.m_searchListenerList = new EventListenerList();
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            this.add((Component)this.createControlsPanel(), "First");
            this.m_searchTab = new JTabbedPane();
            this.m_searchTab.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.add((Component)this.m_searchTab, "Center");
            this.m_searchTab.addChangeListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.m_resultTypeCMB != null) {
            this.m_resultTypeCMB.requestFocus();
        }
    }

    public void addPerformSearchListener(IVWAdminPerformSearchListener apsl) {
        this.m_searchListenerList.add(IVWAdminPerformSearchListener.class, apsl);
    }

    public void removePerformSearchListener(IVWAdminPerformSearchListener apsl) {
        this.m_searchListenerList.remove(IVWAdminPerformSearchListener.class, apsl);
    }

    public boolean getDetailedFlag() {
        this.m_bDetailMode = this.m_editRadioButton.isSelected();
        return this.m_bDetailMode;
    }

    public int getMaxReturned() {
        Integer newValue = new Integer(this.m_maxReturnedTextField.getText());
        this.m_maxReturned = newValue;
        return this.m_maxReturned;
    }

    public void setMaxReturned(int nMaxReturned) {
        if (this.m_maxReturnedTextField != null) {
            Integer obj = nMaxReturned;
            this.m_maxReturnedTextField.setText(((Object)obj).toString());
        }
    }

    public void performNewSearch() {
        VWAdminPerformSearchEvent e = new VWAdminPerformSearchEvent(this);
        if (e == null) {
            return;
        }
        this.fireNewSearch(e);
        if (!e.getCanceledFlag()) {
            this.initializeTabControl();
        }
    }

    public void performFindNow() {
        if (this.validateTextField()) {
            this.createAndSendEvent();
        }
    }

    public void performSearchCount() {
        this.createAndSendSearchCountEvent();
    }

    public void setSession(VWSession session) {
        String[] rosterNames = null;
        String[] queueNames = null;
        String[] userQueueNames = null;
        Object[] workQueueNames = null;
        String[] systemQueueNames = null;
        Object[] componentQueueNames = null;
        String[] eventLogNames = null;
        VWBaseSearchOptions[] options = null;
        VWBaseSearchOptions option = null;
        try {
            this.m_vwSession = session;
            this.initializeComboBox(this.m_scopeCMB, null);
            this.initializeComboBox(this.m_specificScopeCMB, null);
            this.m_executeButton.setEnabled(false);
            this.m_newSearchButton.setEnabled(false);
            this.m_searchCountButton.setEnabled(false);
            this.m_searchTab.removeAll();
            if (session != null) {
                rosterNames = session.fetchRosterNames(false);
                queueNames = session.fetchQueueNames(7);
                userQueueNames = session.fetchQueueNames(2);
                String[] processQueueNames = session.fetchQueueNames(1);
                Vector<String> v_processQueues = new Vector<String>();
                Vector<String> v_componentQueues = new Vector<String>();
                if (processQueueNames != null) {
                    for (int i = 0; i < processQueueNames.length; ++i) {
                        VWQueue vwQueue = session.getQueue(processQueueNames[i]);
                        if (vwQueue == null) continue;
                        if (vwQueue.getIsConnectorQueue()) {
                            v_componentQueues.addElement(processQueueNames[i]);
                            continue;
                        }
                        v_processQueues.addElement(processQueueNames[i]);
                    }
                }
                if (v_processQueues.size() > 0) {
                    workQueueNames = new String[v_processQueues.size()];
                    v_processQueues.copyInto(workQueueNames);
                }
                if (v_componentQueues.size() > 0) {
                    componentQueueNames = new String[v_componentQueues.size()];
                    v_componentQueues.copyInto(componentQueueNames);
                }
                systemQueueNames = session.fetchQueueNames(4);
                eventLogNames = session.fetchEventLogNames();
                options = new VWBaseSearchOptions[3];
                option = new VWWorkflowSearchOptions();
                option.setRosterNames(rosterNames);
                options[0] = option;
                option = new VWWorkflowObjectSearchOptions();
                option.setRosterNames(rosterNames);
                option.setUserQueueNames(userQueueNames);
                option.setWorkQueueNames((String[])workQueueNames);
                option.setSystemQueueNames(systemQueueNames);
                option.setComponentQueueNames((String[])componentQueueNames);
                options[1] = option;
                option = new VWEventLogSearchOptions();
                option.setEventLogNames(eventLogNames);
                options[2] = option;
                this.m_executeButton.setEnabled(true);
                this.m_newSearchButton.setEnabled(true);
                this.m_searchCountButton.setEnabled(true);
            }
            this.initializeComboBox(this.m_resultTypeCMB, options);
            if (this.m_resultTypeCMB.getItemCount() > 0) {
                this.m_resultTypeCMB.setSelectedIndex(0);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            JOptionPane.showMessageDialog(this.m_parentFrame, ex.getLocalizedMessage(), VWResource.s_errorMessage, 0);
        }
    }

    public boolean getIsCurrentTime() {
        boolean bCurrentTime = true;
        if (this.m_rosterQueueSelectionPanel == null) {
            return bCurrentTime;
        }
        return this.m_rosterQueueSelectionPanel.getIsCurrentTime();
    }

    public void stateChanged(ChangeEvent event) {
        if (event.getSource() == this.m_searchTab && this.m_resultTypeCMB.getSelectedItem() instanceof VWStatisticsSearchOptions && this.m_searchTab.getSelectedComponent() instanceof VWSelectColumnsPanel) {
            this.updateColumnsPanel();
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object source = null;
        source = event.getSource();
        if (source == this.m_resultTypeCMB) {
            this.m_resultTypeCMB.hidePopup();
            this.initializeScopeComboBox();
            this.enableDisableSearchMode();
            this.enableDisableMaxReturned();
        } else if (source == this.m_scopeCMB) {
            this.m_scopeCMB.hidePopup();
            this.initializeSpecificScopeComboBox();
        } else if (source == this.m_specificScopeCMB) {
            this.m_specificScopeCMB.hidePopup();
            this.initializeTabControl();
        } else if (source == this.m_executeButton) {
            this.performFindNow();
        } else if (source == this.m_newSearchButton) {
            this.performNewSearch();
        } else if (source == this.m_searchCountButton) {
            this.performSearchCount();
        } else if (source == this.m_maxReturnedTextField) {
            this.validateTextField();
        }
    }

    private JPanel createControlsPanel() {
        JPanel panel = null;
        GridBagConstraints gbCons = null;
        Object[] buttons = null;
        try {
            panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            gbCons = new GridBagConstraints();
            gbCons.anchor = 21;
            gbCons.fill = 2;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.weightx = 0.3;
            gbCons.insets = new Insets(1, 1, 1, 30);
            panel.add((Component)this.createOptionPanel(), gbCons);
            buttons = new Object[3];
            this.m_executeButton = new JButton(VWResource.s_searchNow);
            buttons[0] = this.m_executeButton;
            this.m_executeButton.setEnabled(false);
            this.m_executeButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_executeButton, this, VWResource.s_searchNow, VWResource.s_searchNow);
            this.m_searchCountButton = new JButton(VWResource.s_searchCount);
            buttons[1] = this.m_searchCountButton;
            this.m_searchCountButton.setEnabled(false);
            this.m_searchCountButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_searchCountButton, this, VWResource.s_searchCount, VWResource.s_searchCount);
            this.m_newSearchButton = new JButton(VWResource.s_newSearch);
            buttons[2] = this.m_newSearchButton;
            this.m_newSearchButton.setEnabled(false);
            this.m_newSearchButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_newSearchButton, this, VWResource.s_newSearch, VWResource.s_newSearch);
            gbCons.gridwidth = -1;
            gbCons.weightx = 0.3;
            gbCons.insets = new Insets(1, 1, 1, 40);
            panel.add((Component)this.createModePanel(), gbCons);
            gbCons.gridwidth = 0;
            gbCons.weightx = 0.0;
            gbCons.fill = 0;
            gbCons.insets = new Insets(1, 1, 1, 5);
            panel.add((Component)this.createButtonPanel(buttons), gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return panel;
    }

    private JPanel createOptionPanel() throws Exception {
        JPanel subPanel = null;
        GridBagConstraints gbCons = null;
        try {
            subPanel = new JPanel();
            subPanel.setLayout(new GridBagLayout());
            gbCons = new GridBagConstraints();
            gbCons.anchor = 21;
            gbCons.weightx = 1.0;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(1, 1, 5, 15);
            gbCons.fill = 0;
            JLabel lookForLabel = new JLabel(VWResource.s_lookFor);
            VWAccessibilityHelper.setAccessibility(lookForLabel, this, VWResource.s_lookFor, VWResource.s_lookFor);
            subPanel.add((Component)lookForLabel, gbCons);
            gbCons.gridwidth = 0;
            gbCons.insets = new Insets(1, 1, 5, 1);
            gbCons.fill = 2;
            this.m_resultTypeCMB = new JComboBox();
            this.m_resultTypeCMB.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
            this.m_resultTypeCMB.addActionListener(this);
            this.m_resultTypeCMB.setRenderer(this.m_customComBoBoxRenderer);
            VWAccessibilityHelper.setAccessibility(this.m_resultTypeCMB, this, VWResource.s_lookFor, VWResource.s_lookFor);
            VWAccessibilityHelper.setLabelFor(lookForLabel, this.m_resultTypeCMB);
            subPanel.add((Component)this.m_resultTypeCMB, gbCons);
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(1, 1, 5, 15);
            gbCons.fill = 0;
            JLabel inLabel = new JLabel(VWResource.s_in);
            VWAccessibilityHelper.setAccessibility(inLabel, this, VWResource.s_in, VWResource.s_in);
            subPanel.add((Component)inLabel, gbCons);
            gbCons.gridwidth = 0;
            gbCons.insets = new Insets(1, 1, 5, 1);
            gbCons.fill = 2;
            this.m_scopeCMB = new JComboBox();
            this.m_scopeCMB.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
            this.m_scopeCMB.addActionListener(this);
            this.m_scopeCMB.setRenderer(this.m_customComBoBoxRenderer);
            VWAccessibilityHelper.setAccessibility(this.m_scopeCMB, this, VWResource.s_in, VWResource.s_in);
            VWAccessibilityHelper.setLabelFor(inLabel, this.m_scopeCMB);
            subPanel.add((Component)this.m_scopeCMB, gbCons);
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(1, 1, 5, 15);
            gbCons.fill = 0;
            JLabel selectOneLabel = new JLabel(VWResource.s_selectOne);
            VWAccessibilityHelper.setAccessibility(selectOneLabel, this, VWResource.s_selectOne, VWResource.s_selectOne);
            subPanel.add((Component)selectOneLabel, gbCons);
            gbCons.gridwidth = 0;
            gbCons.insets = new Insets(1, 1, 5, 1);
            gbCons.fill = 2;
            this.m_specificScopeCMB = new JComboBox();
            this.m_specificScopeCMB.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
            this.m_specificScopeCMB.addActionListener(this);
            this.m_specificScopeCMB.setRenderer(this.m_customComBoBoxRenderer);
            VWAccessibilityHelper.setAccessibility(this.m_specificScopeCMB, this, VWResource.s_selectOne, VWResource.s_selectOne);
            VWAccessibilityHelper.setLabelFor(selectOneLabel, this.m_specificScopeCMB);
            subPanel.add((Component)this.m_specificScopeCMB, gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            throw ex;
        }
        return subPanel;
    }

    private JPanel createModePanel() throws Exception {
        JPanel subPanel = null;
        JPanel tinyPanel = null;
        GridBagConstraints gbCons = null;
        try {
            subPanel = new JPanel();
            subPanel.setLayout(new GridBagLayout());
            gbCons = new GridBagConstraints();
            gbCons.anchor = 21;
            gbCons.fill = 2;
            gbCons.insets = new Insets(1, 1, 1, 1);
            gbCons.gridwidth = 0;
            gbCons.gridx = 0;
            gbCons.weightx = 1.0;
            this.m_buttonGroup = new ButtonGroup();
            gbCons.gridy = 0;
            gbCons.insets = new Insets(1, 1, 1, 1);
            JLabel searchModeLabel = new JLabel(VWResource.s_searchMode);
            VWAccessibilityHelper.setAccessibility(searchModeLabel, this, VWResource.s_searchMode, VWResource.s_searchMode);
            subPanel.add((Component)searchModeLabel, gbCons);
            gbCons.gridy = 1;
            gbCons.insets = new Insets(1, 20, 1, 1);
            this.m_readRadioButton = new JRadioButton(VWResource.s_readMode, true);
            this.m_readRadioButton.setMargin(new Insets(0, 0, 0, 0));
            VWAccessibilityHelper.setMemberOf(this.m_readRadioButton, this.m_buttonGroup);
            VWAccessibilityHelper.setAccessibility(this.m_readRadioButton, subPanel, VWResource.s_readMode, VWResource.s_readMode);
            subPanel.add((Component)this.m_readRadioButton, gbCons);
            gbCons.gridy = 2;
            gbCons.insets = new Insets(1, 20, 1, 1);
            this.m_editRadioButton = new JRadioButton(VWResource.s_editMode, false);
            this.m_editRadioButton.setMargin(new Insets(0, 0, 0, 0));
            VWAccessibilityHelper.setMemberOf(this.m_editRadioButton, this.m_buttonGroup);
            VWAccessibilityHelper.setAccessibility(this.m_editRadioButton, subPanel, VWResource.s_editMode, VWResource.s_editMode);
            subPanel.add((Component)this.m_editRadioButton, gbCons);
            this.m_buttonGroup.add(this.m_readRadioButton);
            this.m_buttonGroup.add(this.m_editRadioButton);
            tinyPanel = new JPanel();
            tinyPanel.setLayout(new BorderLayout());
            tinyPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            JLabel maxReturnLabel = new JLabel(VWResource.s_maxReturn);
            VWAccessibilityHelper.setAccessibility(maxReturnLabel, this, VWResource.s_maxReturn, VWResource.s_maxReturn);
            tinyPanel.add((Component)maxReturnLabel, "Before");
            this.m_maxReturnedTextField = new JTextField(10);
            this.m_enabledBkgrndColor = this.m_maxReturnedTextField.getBackground();
            Integer obj = this.m_maxReturned;
            this.m_maxReturnedTextField.setText(((Object)obj).toString());
            tinyPanel.add((Component)this.m_maxReturnedTextField, "Center");
            this.m_maxReturnedTextField.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_maxReturnedTextField, this, VWResource.s_maxReturn, VWResource.s_maxReturn);
            VWAccessibilityHelper.setLabelFor(maxReturnLabel, this.m_maxReturnedTextField);
            gbCons.gridy = 3;
            gbCons.insets = new Insets(1, 1, 1, 1);
            subPanel.add((Component)tinyPanel, gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            throw ex;
        }
        return subPanel;
    }

    private JPanel createButtonPanel(Object[] buttons) throws Exception {
        JPanel subPanel = null;
        GridBagConstraints gbConst = null;
        try {
            subPanel = new JPanel();
            subPanel.setLayout(new GridBagLayout());
            gbConst = new GridBagConstraints();
            gbConst.gridwidth = 0;
            gbConst.anchor = 10;
            gbConst.fill = 2;
            gbConst.insets = new Insets(4, 4, 4, 4);
            for (int i = 0; i < buttons.length; ++i) {
                subPanel.add((Component)((JButton)buttons[i]), gbConst);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            throw ex;
        }
        return subPanel;
    }

    private void initializeScopeComboBox() {
        VWBaseSearchOptions optionItem = null;
        try {
            if (this.m_resultTypeCMB == null || this.m_scopeCMB == null) {
                return;
            }
            optionItem = (VWBaseSearchOptions)this.m_resultTypeCMB.getSelectedItem();
            if (optionItem != null) {
                this.initializeComboBox(this.m_scopeCMB, optionItem.getScopeOptions());
                if (this.m_scopeCMB.getItemCount() > 0) {
                    this.m_scopeCMB.setSelectedIndex(0);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void initializeSpecificScopeComboBox() {
        VWBaseSearchOptions optionItem = null;
        try {
            if (this.m_resultTypeCMB == null || this.m_specificScopeCMB == null) {
                return;
            }
            optionItem = (VWBaseSearchOptions)this.m_resultTypeCMB.getSelectedItem();
            if (optionItem != null) {
                optionItem.setScope((String)this.m_scopeCMB.getSelectedItem());
                Object[] items = optionItem.getSpecificScopeOptions();
                if (items != null && items.length > 0) {
                    VWQuickSort sort = new VWQuickSort(items, 0);
                    sort.sort(0, items.length - 1);
                }
                this.initializeComboBox(this.m_specificScopeCMB, items);
                if (this.m_specificScopeCMB.getItemCount() > 0) {
                    this.m_specificScopeCMB.setSelectedIndex(0);
                } else {
                    this.initializeTabControl();
                }
                if (optionItem.getResultType() == 4) {
                    this.m_specificScopeCMB.setEnabled(false);
                    this.m_searchCountButton.setEnabled(false);
                } else {
                    this.m_specificScopeCMB.setEnabled(true);
                    this.m_searchCountButton.setEnabled(true);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeComboBox(JComboBox comboBox, Object[] items) {
        try {
            comboBox.removeActionListener(this);
            DefaultComboBoxModel dataModel = (DefaultComboBoxModel)comboBox.getModel();
            if (dataModel.getSize() > 0) {
                dataModel.removeAllElements();
            }
            if (items != null) {
                for (int i = 0; i < items.length; ++i) {
                    dataModel.addElement(items[i]);
                }
            }
            comboBox.setSelectedIndex(-1);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        finally {
            comboBox.addActionListener(this);
        }
    }

    private void initializeTabControl() {
        VWBaseSearchOptions optionItem = null;
        VWScopeChangeEvent vwSCEvent = null;
        try {
            if (this.m_searchTab == null || this.m_resultTypeCMB == null || this.m_specificScopeCMB == null) {
                return;
            }
            optionItem = (VWBaseSearchOptions)this.m_resultTypeCMB.getSelectedItem();
            if (optionItem != null) {
                optionItem.setSpecificScope((String)this.m_specificScopeCMB.getSelectedItem());
                this.addVisibleTabs(optionItem.getVisibleTabs());
                vwSCEvent = optionItem.createScopeChangeEvent(this, this.m_vwSession);
                if (vwSCEvent == null) {
                    return;
                }
                if (this.m_visiblePanels != null) {
                    IVWScopeChangeListener panel = null;
                    for (int i = 0; i < this.m_visiblePanels.size(); ++i) {
                        panel = (IVWScopeChangeListener)this.m_visiblePanels.elementAt(i);
                        panel.scopeChanged(vwSCEvent);
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void addVisibleTabs(int nVisibleTabs) {
        try {
            if (this.m_searchTab == null) {
                return;
            }
            this.m_visiblePanels = new Vector();
            this.m_searchTab.removeAll();
            if ((nVisibleTabs & 0x10) != 0) {
                if (this.m_rosterQueueSelectionPanel == null) {
                    this.m_rosterQueueSelectionPanel = new VWRosterQueueSelectionPanel(1);
                } else {
                    this.m_rosterQueueSelectionPanel.setType(1);
                }
                this.m_searchTab.addTab(this.m_rosterQueueSelectionPanel.getDisplayName(), this.m_rosterQueueSelectionPanel);
                this.m_visiblePanels.addElement(this.m_rosterQueueSelectionPanel);
            }
            if ((nVisibleTabs & 0x20) != 0) {
                if (this.m_rosterQueueSelectionPanel == null) {
                    this.m_rosterQueueSelectionPanel = new VWRosterQueueSelectionPanel(0);
                } else {
                    this.m_rosterQueueSelectionPanel.setType(0);
                }
                this.m_searchTab.addTab(this.m_rosterQueueSelectionPanel.getDisplayName(), this.m_rosterQueueSelectionPanel);
                this.m_visiblePanels.addElement(this.m_rosterQueueSelectionPanel);
            }
            if ((nVisibleTabs & 1) != 0) {
                if (this.m_userSelectionPanel == null) {
                    this.m_userSelectionPanel = new VWUserSelectionPanel(this.m_parentFrame, this.m_vwSession);
                }
                this.m_searchTab.addTab(this.m_userSelectionPanel.getDisplayName(), this.m_userSelectionPanel);
                this.m_visiblePanels.addElement(this.m_userSelectionPanel);
            }
            if ((nVisibleTabs & 2) != 0) {
                if (this.m_filterConditionsPanel == null) {
                    this.m_filterConditionsPanel = new VWFilterConditionsPanel(null);
                }
                this.m_searchTab.addTab(this.m_filterConditionsPanel.getDisplayName(), this.m_filterConditionsPanel);
                this.m_visiblePanels.addElement(this.m_filterConditionsPanel);
            }
            if ((nVisibleTabs & 8) != 0) {
                if (this.m_selectColumnsPanel == null) {
                    this.m_selectColumnsPanel = new VWSelectColumnsPanel();
                }
                this.m_searchTab.addTab(this.m_selectColumnsPanel.getDisplayName(), this.m_selectColumnsPanel);
                this.m_visiblePanels.addElement(this.m_selectColumnsPanel);
            }
            if (this.m_searchTab.getComponentCount() > 0) {
                this.m_searchTab.setSelectedIndex(0);
                this.m_searchTab.getComponentAt(0).setVisible(true);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void createAndSendEvent() {
        VWBaseSearchOptions optionItem = null;
        VWAdminPerformSearchEvent event = null;
        int nVisibleTabs = 0;
        try {
            if (this.m_resultTypeCMB == null) {
                return;
            }
            optionItem = (VWBaseSearchOptions)this.m_resultTypeCMB.getSelectedItem();
            if (optionItem == null) {
                return;
            }
            if (optionItem.getResultType() != 4 && optionItem.m_selectedSpecificScope == null) {
                JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_sufficientRights);
                return;
            }
            this.updateColumnsPanel();
            event = optionItem.createPerformSearchEvent(this.m_parentPanel);
            if (event == null) {
                return;
            }
            event.setMaxReturned(this.getMaxReturned());
            event.setDetailedFlag(this.getDetailedFlag());
            nVisibleTabs = optionItem.getVisibleTabs();
            if (((nVisibleTabs & 0x10) != 0 || (nVisibleTabs & 0x20) != 0) && this.m_rosterQueueSelectionPanel != null) {
                event.setStartTime(this.m_rosterQueueSelectionPanel.getStartTime(true));
                event.setEndTime(this.m_rosterQueueSelectionPanel.getEndTime(true));
                event.setTimeUnits(this.m_rosterQueueSelectionPanel.getTimeUnits());
                event.setListOfSelectedItems(this.m_rosterQueueSelectionPanel.getSelectedItems());
            }
            if ((nVisibleTabs & 1) != 0 && this.m_userSelectionPanel != null) {
                event.setListOfUsers(this.m_userSelectionPanel.getSelectedUsers());
            }
            if ((nVisibleTabs & 2) != 0 && this.m_filterConditionsPanel != null) {
                event.setFilterString(this.m_filterConditionsPanel.getFilterString());
                this.m_filterConditionsPanel.getIndexParameters(event);
            }
            if ((nVisibleTabs & 8) != 0 && this.m_selectColumnsPanel != null) {
                event.setColumnNames(this.m_selectColumnsPanel.getSelectedColumns());
            }
            this.fireSelectionChanged(event);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void createAndSendSearchCountEvent() {
        VWBaseSearchOptions optionItem = null;
        VWAdminPerformSearchEvent event = null;
        int nVisibleTabs = 0;
        try {
            if (this.m_resultTypeCMB == null) {
                return;
            }
            optionItem = (VWBaseSearchOptions)this.m_resultTypeCMB.getSelectedItem();
            if (optionItem == null) {
                return;
            }
            if (optionItem.m_selectedSpecificScope == null) {
                JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_sufficientRights);
                return;
            }
            event = optionItem.createPerformSearchEvent(this.m_parentPanel);
            if (event == null) {
                return;
            }
            event.setMaxReturned(this.getMaxReturned());
            event.setDetailedFlag(this.getDetailedFlag());
            event.setExecuteSearchFlag(false);
            nVisibleTabs = optionItem.getVisibleTabs();
            if (((nVisibleTabs & 0x10) != 0 || (nVisibleTabs & 0x20) != 0) && this.m_rosterQueueSelectionPanel != null) {
                event.setStartTime(this.m_rosterQueueSelectionPanel.getStartTime(true));
                event.setEndTime(this.m_rosterQueueSelectionPanel.getEndTime(true));
                event.setTimeUnits(this.m_rosterQueueSelectionPanel.getTimeUnits());
                event.setListOfSelectedItems(this.m_rosterQueueSelectionPanel.getSelectedItems());
            }
            if ((nVisibleTabs & 1) != 0 && this.m_userSelectionPanel != null) {
                event.setListOfUsers(this.m_userSelectionPanel.getSelectedUsers());
            }
            if ((nVisibleTabs & 2) != 0 && this.m_filterConditionsPanel != null) {
                event.setFilterString(this.m_filterConditionsPanel.getFilterString());
                this.m_filterConditionsPanel.getIndexParameters(event);
            }
            this.fireSearchCountEvent(event);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void fireSelectionChanged(VWAdminPerformSearchEvent event) {
        if (event == null) {
            return;
        }
        Object[] listeners = this.m_searchListenerList.getListenerList();
        if (listeners == null) {
            return;
        }
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IVWAdminPerformSearchListener.class) continue;
            ((IVWAdminPerformSearchListener)listeners[i + 1]).searchCriteriaChanged(event);
        }
    }

    private void fireSearchCountEvent(VWAdminPerformSearchEvent event) {
        if (event == null) {
            return;
        }
        Object[] listeners = this.m_searchListenerList.getListenerList();
        if (listeners == null) {
            return;
        }
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IVWAdminPerformSearchListener.class) continue;
            ((IVWAdminPerformSearchListener)listeners[i + 1]).searchCountClicked(event);
        }
    }

    private void fireNewSearch(VWAdminPerformSearchEvent event) {
        if (event == null) {
            return;
        }
        Object[] listeners = this.m_searchListenerList.getListenerList();
        if (listeners == null) {
            return;
        }
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IVWAdminPerformSearchListener.class) continue;
            ((IVWAdminPerformSearchListener)listeners[i + 1]).newSearchClicked(event);
        }
    }

    private boolean validateTextField() {
        String string = this.m_maxReturnedTextField.getText();
        try {
            Integer newValue = new Integer(string);
            if (newValue > 1000) {
                VWConfirmYesNoDialog dlg = new VWConfirmYesNoDialog(this.m_parentFrame, VWResource.s_exceedMaxReturnedWarningDlgTitle, VWResource.s_exceedMaxReturnedWarning, 1);
                dlg.setVisible(true);
                return dlg.isYes();
            }
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_invalidMaxReturned, VWResource.s_error, 1, null);
            return false;
        }
        return true;
    }

    private void enableDisableSearchMode() {
        VWBaseSearchOptions optionItem = (VWBaseSearchOptions)this.m_resultTypeCMB.getSelectedItem();
        if (optionItem != null) {
            if (optionItem.getResultType() == 4 || optionItem.getResultType() == 3) {
                this.m_editRadioButton.setEnabled(false);
                this.m_readRadioButton.setEnabled(false);
            } else {
                this.m_editRadioButton.setEnabled(true);
                this.m_readRadioButton.setEnabled(true);
            }
        }
    }

    private void enableDisableMaxReturned() {
        VWBaseSearchOptions optionItem = (VWBaseSearchOptions)this.m_resultTypeCMB.getSelectedItem();
        if (optionItem != null) {
            if (optionItem.getResultType() == 4) {
                this.m_maxReturnedTextField.setEnabled(false);
                this.m_maxReturnedTextField.setBackground(this.getBackground());
            } else {
                this.m_maxReturnedTextField.setEnabled(true);
                this.m_maxReturnedTextField.setBackground(this.m_enabledBkgrndColor);
            }
        }
    }

    private void updateColumnsPanel() {
        if (!(this.m_resultTypeCMB.getSelectedItem() instanceof VWStatisticsSearchOptions)) {
            return;
        }
        boolean bCurrentTime = this.getIsCurrentTime();
        if (bCurrentTime == this.m_bCurrentTime) {
            return;
        }
        this.m_bCurrentTime = bCurrentTime;
        VWStatisticsSearchOptions optionItem = (VWStatisticsSearchOptions)this.m_resultTypeCMB.getSelectedItem();
        if (optionItem == null) {
            return;
        }
        VWScopeChangeEvent vwSCEvent = optionItem.createScopeChangeEvent(this, this.m_vwSession);
        if (vwSCEvent == null) {
            return;
        }
        IVWScopeChangeListener panel = null;
        for (int i = 0; i < this.m_visiblePanels.size(); ++i) {
            panel = (IVWScopeChangeListener)this.m_visiblePanels.elementAt(i);
            if (!(panel instanceof VWSelectColumnsPanel)) continue;
            panel.scopeChanged(vwSCEvent);
        }
    }

    protected void removeReferences() {
        DefaultComboBoxModel dataModel;
        if (this.m_filterConditionsPanel != null) {
            this.m_filterConditionsPanel.removeReferences();
            this.m_filterConditionsPanel = null;
        }
        this.m_selectColumnsPanel = null;
        this.m_userSelectionPanel = null;
        this.m_rosterQueueSelectionPanel = null;
        if (this.m_visiblePanels != null) {
            this.m_visiblePanels.removeAllElements();
            this.m_visiblePanels = null;
        }
        if (this.m_resultTypeCMB != null) {
            dataModel = (DefaultComboBoxModel)this.m_resultTypeCMB.getModel();
            if (dataModel != null && dataModel.getSize() > 0) {
                dataModel.removeAllElements();
            }
            this.m_resultTypeCMB = null;
        }
        if (this.m_scopeCMB != null) {
            dataModel = (DefaultComboBoxModel)this.m_scopeCMB.getModel();
            if (dataModel != null && dataModel.getSize() > 0) {
                dataModel.removeAllElements();
            }
            this.m_scopeCMB = null;
        }
        if (this.m_specificScopeCMB != null) {
            dataModel = (DefaultComboBoxModel)this.m_specificScopeCMB.getModel();
            if (dataModel != null && dataModel.getSize() > 0) {
                dataModel.removeAllElements();
            }
            this.m_specificScopeCMB = null;
        }
        if (this.m_searchTab != null) {
            this.m_searchTab.removeAll();
            this.m_searchTab = null;
        }
        this.m_maxReturnedTextField = null;
        this.m_parentFrame = null;
        this.m_parentPanel = null;
        this.m_searchListenerList = null;
    }
}

